' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Collections.Generic
Imports System.Data

Partial Class _Default
  Inherits System.Web.UI.Page
  Private myBugManager As BugManager

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    Helpers.SetMemberId()
    myBugManager = New BugManager(Helpers.GetMemberId)
    If Page.IsPostBack Then
      ' Po ponownym wywoaniu strony poka odnoniki rozwi / zwi 
      reportingSection.Attributes.Remove("style")
      plcExpandCollapsePanel.Visible = False
    End If
  End Sub

  Protected Sub lstApplications_SelectedIndexChanged( _
       ByVal sender As Object, ByVal e As System.EventArgs) _
       Handles lstApplications.SelectedIndexChanged
    ' Uczy kontrolk lstFeature znw widoczn. Dziki temu ObjectDataSource powie si z ni
    lstFeature.Visible = True
    lstFeature.Items.Clear()
    lstFeature.Items.Insert(0, New ListItem("[Nie filtruj]", ""))
    lstFeature.Items(0).Selected = True
  End Sub

  Protected Sub odsFeature_Selected(ByVal sender As Object, ByVal e _
     As System.Web.UI.WebControls.ObjectDataSourceStatusEventArgs) _
   Handles odsFeature.Selected
    ' Ukryj list rozwijan Funkcja aplikacji, gdy nie wybrano adej aplikacji, lub
    ' aplikacja nie posiada adnych funkcji
    Dim featureListVisible As Boolean = (CType(e.ReturnValue, DataSet)).Tables(0).Rows.Count > 0
    lstFeature.Visible = featureListVisible
    lblFeature.Visible = featureListVisible
  End Sub

  Protected Sub odsBugList_Selecting(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ObjectDataSourceSelectingEventArgs) Handles odsBugList.Selecting
    ' Zbuduj obiekt SearchCriteria i ustaw mu waciwoci
    Dim searchCriteria As SearchCriteria = New SearchCriteria()

    ' Ustaw aplikacj, jeli jest wybrana
    If Not lstApplications.SelectedValue = "" Then
      searchCriteria.ApplicationId = Convert.ToInt32(lstApplications.SelectedValue)
    End If

    ' Ustaw funkcj aplikacji, jeli jest wybrana
    For Each myItem As ListItem In lstFeature.Items
      If myItem.Selected = True Then
        searchCriteria.AddFeature(myItem.Value)
      End If
    Next

    ' Przypisz warto FiledBy, jeli jest wybrane
    For Each myItem As ListItem In lstMember.Items
      If myItem.Selected = True Then
        searchCriteria.AddFiledBy(myItem.Value)
      End If
    Next

    ' Ustaw istotno, jeli jest wybrana
    For Each myItem As ListItem In lstSeverity.Items
      If myItem.Selected = True Then
        searchCriteria.AddSeverity(myItem.Value)
      End If
    Next

    ' Ustaw status, jeli jest wybrany
    For Each myItem As ListItem In lstStatus.Items
      If myItem.Selected = True Then
        searchCriteria.AddStatus(myItem.Value)
      End If
    Next

    ' Ustaw priorytet, jeli jest wybrany
    For Each myItem As ListItem In lstPriority.Items
      If myItem.Selected = True Then
        searchCriteria.AddPriority(myItem.Value)
      End If
    Next

    ' Ustaw dat pocztkow
    If Not calStartDate.SelectedDate = DateTime.MinValue Then
      searchCriteria.StartDate = calStartDate.SelectedDate
    End If

    ' Ustaw dat kocow
    If Not calEndDate.SelectedDate = DateTime.MinValue Then
      searchCriteria.EndDate = calEndDate.SelectedDate
    End If

    ' Przdziel obiekt SearchCriteria do kolekcji InputParameters obiektu DataSource
    ' Tym sposobem kryteria wyszukiwania s przesyane do metody select dla ods (Open Data Services)
    e.InputParameters.Item(1) = searchCriteria
  End Sub

  Protected Sub odsBugList_ObjectCreating(ByVal sender As Object, _
        ByVal e As System.Web.UI.WebControls.ObjectDataSourceEventArgs) _
        Handles odsBugList.ObjectCreating
    ' Przydziel obiekt BugManager do ObjectDataSource, eby mg wywoywac metody na tym obiekcie.
    e.ObjectInstance = myBugManager
  End Sub

  Private Sub LoadData()
    GridView1.Visible = True
    GridView1.DataSourceID = "odsBugList"
    GridView1.DataBind()
  End Sub

  Private Sub HideGridView()
    GridView1.Visible = False
  End Sub

  Protected Sub GridView1_DataBound(ByVal sender As Object, ByVal e As System.EventArgs) Handles GridView1.DataBound
    ' Wywietl etykiet z iloci bedw.
    If myBugManager.Count > 0 Then
      If myBugManager.Count = 1 Then
        lblNumRecords.Text = "Znaleziono 1 bd"
      Else
        lblNumRecords.Text = "Znalezione bdy: " + myBugManager.Count.ToString()
      End If
    Else
      lblNumRecords.Text = "Nie znaleziono bdw"
    End If

    ' Sformatuj nasz pasek z odnonikami do stron
    If GridView1.TopPagerRow IsNot Nothing Then
      Helpers.FormatGridViewPagerBar(GridView1.TopPagerRow)
    End If
    If GridView1.BottomPagerRow IsNot Nothing Then
      Helpers.FormatGridViewPagerBar(GridView1.BottomPagerRow)
    End If
  End Sub

  Protected Sub btnReport_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnReport.Click
    ' Podczas obsugi dania postback, ukryj element div zawierajcy kryteria wyszukiwania za pomoc Css po stronie klienta
    reportingSection.Attributes("style") += "display: none;"
    plcExpandCollapsePanel.Visible = True
    LoadData()
  End Sub

  Protected Sub calStartDate_SelectionChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles calStartDate.SelectionChanged
    ' Wywietl wybran dat w etykiecie
    lblStartDate.Text = ": " & calStartDate.SelectedDate.ToShortDateString()
    HideGridView()
  End Sub

  Protected Sub calEndDate_SelectionChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles calEndDate.SelectionChanged
    ' Wywietl wybran dat w etykiecie
    lblEndDate.Text = ": " & calEndDate.SelectedDate.ToShortDateString()
    HideGridView()
  End Sub

  Protected Sub btnClearStartDate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnClearStartDate.Click
    ' Wyczy wybran dat i zwiazan z ni etykiet
    calStartDate.SelectedDate = Nothing
    lblStartDate.Text = ""
    HideGridView()
  End Sub

  Protected Sub btnClearEndDate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnClearEndDate.Click
    ' Wyczy wybran dat i zwiazan z ni etykiet
    calEndDate.SelectedDate = Nothing
    lblEndDate.Text = ""
    HideGridView()
  End Sub

  Protected Sub GridView1_Sorted(ByVal sender As Object, ByVal e As System.EventArgs) Handles GridView1.Sorted
    reportingSection.Attributes("style") += "display: none;"
    plcExpandCollapsePanel.Visible = True
  End Sub

  Protected Sub GridView1_PageIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles GridView1.PageIndexChanged
    reportingSection.Attributes("style") += "display: none;"
    plcExpandCollapsePanel.Visible = True
  End Sub
End Class
